<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once 'vendor/autoload.php';
spl_autoload_register(function ($class) {
    include 'classes/' . $class . '.php';
});

// Initialize objects
$contact = new Contact();
$message = new Message();
$callLogger = new Call(); // Add Call class initialization

// Handle AJAX requests
if (isset($_GET['ajax'])) {
    header('Content-Type: application/json');
    
    switch ($_GET['ajax']) {
        case 'get_voice_token':
            try {
                $config = Config::getInstance();
                
                // Create access token
                $token = new Twilio\Jwt\AccessToken(
                    $config->get('twilio.account_sid'),
                    $config->get('twilio.api_key'),
                    $config->get('twilio.api_secret'),
                    3600,
                    'browser_user'
                );

                // Create Voice grant
                $voiceGrant = new Twilio\Jwt\Grants\VoiceGrant();
                $voiceGrant->setOutgoingApplicationSid($config->get('twilio.app_sid'));
                $voiceGrant->setIncomingAllow(true);

                // Add grant to token
                $token->addGrant($voiceGrant);

                echo json_encode([
                    'success' => true,
                    'token' => $token->toJWT()
                ]);
            } catch (Exception $e) {
                echo json_encode([
                    'success' => false,
                    'error' => $e->getMessage()
                ]);
            }
            exit;

        case 'get_messages':
            $messages = $message->getContactMessages($_GET['contact_id']);
            echo json_encode(['success' => true, 'messages' => $messages]);
            exit;

        case 'check_new_messages':
            $lastId = $_GET['last_id'] ?? 0;
            $messages = $message->getNewMessages($_GET['contact_id'], $lastId);
            echo json_encode(['success' => true, 'messages' => $messages]);
            exit;

        case 'send_message':
            $result = $message->send(
                $_POST['contact_id'],
                $_POST['to'],
                $_POST['message']
            );
            echo json_encode($result);
            exit;

        case 'update_contact':
            $result = $contact->update($_POST['id'], [
                'name' => $_POST['name'],
                'phone' => $_POST['phone'],
                'email' => $_POST['email'],
                'notes' => $_POST['notes']
            ]);
            echo json_encode(['success' => $result]);
            exit;
    }
}

// Basic routing
$page = $_GET['page'] ?? 'contacts';
$action = $_GET['action'] ?? 'index';

// Start output buffering
ob_start();

// Route to appropriate view
switch ($page) {
    case 'contacts':
        switch ($action) {
            case 'view':
                if (isset($_GET['id'])) {
                    $contactData = $contact->getById($_GET['id']);
                    if ($contactData) {
                        $messages = $message->getContactMessages($_GET['id']);
                        $calls = $callLogger->getByContactId($_GET['id']); // Add calls data
                        include 'views/contacts/view.php';
                    } else {
                        echo "Contact not found.";
                    }
                } else {
                    echo "No contact ID provided.";
                }
                break;
            
            default:
                $contacts = $contact->getAll();
                include 'views/contacts/index.php';
                break;
        }
        break;

    default:
        header('Location: ?page=contacts');
        exit;
}

// Get buffered content
$content = ob_get_clean();

// Include the layout
include 'templates/layout.php';
?>