<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('log_errors', 1);
ini_set('error_log', dirname(__FILE__) . '/call_status.log');

require_once dirname(__FILE__) . '/../vendor/autoload.php';
require_once dirname(__FILE__) . '/../classes/Config.php';
require_once dirname(__FILE__) . '/../classes/Call.php';

try {
    // Log incoming request
    error_log("Call Status Webhook Request: " . print_r($_POST, true));

    $callSid = $_POST['CallSid'] ?? null;
    $callStatus = $_POST['CallStatus'] ?? null;
    $duration = $_POST['CallDuration'] ?? null;
    $recordingUrl = $_POST['RecordingUrl'] ?? null;

    error_log("Processing status update - SID: $callSid, Status: $callStatus, Duration: $duration");

    if ($callSid && $callStatus) {
        $callLogger = new Call();
        $result = $callLogger->updateStatus($callSid, $callStatus, $duration);
        error_log("Call status update " . ($result ? "successful" : "failed"));
    }

    // Send success response
    http_response_code(200);
    echo 'Status update processed';

} catch (Exception $e) {
    error_log("Call Status Error: " . $e->getMessage());
    error_log("Stack trace: " . $e->getTraceAsString());
    http_response_code(500);
    echo 'Error processing status';
}
?>