<?php
require_once dirname(__FILE__) . '/../vendor/autoload.php';
require_once dirname(__FILE__) . '/../classes/Config.php';

use Twilio\TwiML\VoiceResponse;

try {
    echo "Testing Twilio class loading...<br>";
    
    $response = new VoiceResponse();
    $response->say('Test successful');
    
    echo "VoiceResponse created successfully!<br>";
    echo "Generated TwiML:<br>";
    echo "<pre>";
    echo htmlspecialchars($response->asXML());
    echo "</pre>";
    
} catch (Exception $e) {
    echo "Error:<br>";
    echo "<pre>";
    echo "Message: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . "\n";
    echo "Line: " . $e->getLine() . "\n";
    echo "Stack Trace:\n" . $e->getTraceAsString();
    echo "</pre>";
}
?>