<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('log_errors', 1);
ini_set('error_log', dirname(__FILE__) . '/voice_handler.log');

require_once dirname(__FILE__) . '/../vendor/autoload.php';
require_once dirname(__FILE__) . '/../classes/Config.php';
require_once dirname(__FILE__) . '/../classes/Call.php';

use Twilio\TwiML\VoiceResponse;

try {
    // Log incoming request
    error_log("Voice Handler Request - POST: " . print_r($_POST, true));
    error_log("Voice Handler Request - GET: " . print_r($_GET, true));

    $config = Config::getInstance();
    $response = new VoiceResponse();

    // Get the phone number and call details
    $to = $_REQUEST['To'] ?? null;
    $from = $_REQUEST['From'] ?? null;
    $callSid = $_REQUEST['CallSid'] ?? null;
    $direction = isset($_REQUEST['Direction']) ? strtolower($_REQUEST['Direction']) : 'outbound';

    error_log("Processing call - From: $from, To: $to, Direction: $direction, SID: $callSid");

    if ($to) {
        // Format the phone number
        $to = preg_replace('/[^+0-9]/', '', $to);

        // Set up the dial verb with options
        $dial = $response->dial('', [
            'callerId' => $config->get('twilio.phone_number'),
            'record' => 'record-from-answer',
            'recordingStatusCallback' => 'https://' . $_SERVER['HTTP_HOST'] . '/tw/webhooks/recording-status.php',
            'recordingStatusCallbackEvent' => ['completed'],
            'answerOnBridge' => true,
            'ringTone' => 'us',
            'timeLimit' => 14400, // 4 hours
            'timeout' => 30,
            'action' => 'https://' . $_SERVER['HTTP_HOST'] . '/tw/webhooks/call-status.php',
            'method' => 'POST'
        ]);

        // Add the number to dial
        $dial->number($to, [
            'statusCallbackEvent' => ['initiated', 'ringing', 'answered', 'completed'],
            'statusCallback' => 'https://' . $_SERVER['HTTP_HOST'] . '/tw/webhooks/call-status.php',
            'statusCallbackMethod' => 'POST'
        ]);

        // Log call in database
        try {
            $callLogger = new Call();
            $callLogger->create([
                'contact_id' => $_REQUEST['contact_id'] ?? null,
                'direction' => $direction,
                'status' => 'initiated',
                'start_time' => date('Y-m-d H:i:s'),
                'twilio_sid' => $callSid,
                'notes' => null
            ]);
            error_log("Call logged successfully in database");
        } catch (Exception $e) {
            error_log("Error logging call: " . $e->getMessage());
        }

        error_log("Dial TwiML generated for number: $to");
    } else {
        $response->say('No valid phone number provided.', [
            'voice' => 'alice',
            'language' => 'en-US'
        ]);
        error_log("No valid 'To' number provided");
    }

    // Send response
    header('Content-Type: text/xml');
    $twimlString = $response->asXML();
    error_log("Sending TwiML response: " . $twimlString);
    echo $twimlString;

} catch (Exception $e) {
    error_log("Voice Handler Error: " . $e->getMessage());
    error_log("Stack trace: " . $e->getTraceAsString());
    
    // Send a basic response in case of error
    header('Content-Type: text/xml');
    $response = new VoiceResponse();
    $response->say('An error occurred while processing your call.', [
        'voice' => 'alice',
        'language' => 'en-US'
    ]);
    echo $response;
}
?>