<?php
class Contact {
    private $db;
    
    public function __construct() {
        $this->db = Database::getInstance();
    }

    public function getAll() {
        $sql = "SELECT * FROM contacts ORDER BY created_at DESC";
        $stmt = $this->db->getPdo()->prepare($sql);
        $stmt->execute();
        return $stmt->fetchAll();
    }

    public function getById($id) {
        $sql = "SELECT * FROM contacts WHERE id = ?";
        $stmt = $this->db->getPdo()->prepare($sql);
        $stmt->execute([$id]);
        return $stmt->fetch();
    }

    public function findByPhone($phone) {
        // Clean the phone number
        $phone = preg_replace('/[^+0-9]/', '', $phone);
        
        $sql = "SELECT * FROM contacts WHERE REPLACE(REPLACE(phone, '+', ''), ' ', '') = REPLACE(REPLACE(?, '+', ''), ' ', '')";
        $stmt = $this->db->getPdo()->prepare($sql);
        $stmt->execute([$phone]);
        return $stmt->fetch();
    }

    public function create($data) {
        $sql = "INSERT INTO contacts (name, phone, email, notes) VALUES (?, ?, ?, ?)";
        $stmt = $this->db->getPdo()->prepare($sql);
        return $stmt->execute([
            $data['name'], 
            $data['phone'], 
            $data['email'], 
            $data['notes']
        ]);
    }

    public function update($id, $data) {
        $sql = "UPDATE contacts SET name = ?, phone = ?, email = ?, notes = ? WHERE id = ?";
        $stmt = $this->db->getPdo()->prepare($sql);
        return $stmt->execute([
            $data['name'],
            $data['phone'],
            $data['email'],
            $data['notes'],
            $id
        ]);
    }

    public function delete($id) {
        $sql = "DELETE FROM contacts WHERE id = ?";
        $stmt = $this->db->getPdo()->prepare($sql);
        return $stmt->execute([$id]);
    }
}