<?php
class Database {
    private static $instance = null;
    private $pdo;

    private function __construct() {
        $config = Config::getInstance();
        try {
            $this->pdo = new PDO(
                "mysql:host=" . $config->get('db.host') . 
                ";dbname=" . $config->get('db.name'),
                $config->get('db.user'),
                $config->get('db.pass')
            );
            $this->pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $this->pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
        } catch (PDOException $e) {
            die("Connection failed: " . $e->getMessage());
        }
    }

    public static function getInstance() {
        if (self::$instance == null) {
            self::$instance = new Database();
        }
        return self::$instance;
    }

    public function getPdo() {
        return $this->pdo;
    }

    public function query($sql, $params = []) {
        $stmt = $this->pdo->prepare($sql);
        $stmt->execute($params);
        return $stmt;
    }
}