<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CRM System</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://sdk.twilio.com/js/client/v1.14/twilio.min.js"></script>
    <link href="assets/css/style.css" rel="stylesheet">
    <link href="assets/css/chat.css" rel="stylesheet">
</head>
<body class="bg-gray-100">
    <div class="min-h-screen">
        <!-- Header -->
        <header class="bg-white shadow">
            <div class="max-w-7xl mx-auto px-4 py-6">
                <nav class="flex justify-between">
                    <div class="flex items-center">
                        <a href="?page=contacts" class="text-xl font-bold text-gray-900">CRM System</a>
                    </div>
                    <div class="flex items-center space-x-4">
                        <a href="?page=contacts" class="text-gray-600 hover:text-gray-900">Contacts</a>
                        <!-- Add more nav items here -->
                    </div>
                </nav>
            </div>
        </header>

        <!-- Main Content -->
        <main class="max-w-7xl mx-auto px-4 py-6">
            <?php echo $content; ?>
        </main>
    </div>
</body>
</html>