<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Test autoloader
spl_autoload_register(function ($class) {
    $file = 'classes/' . $class . '.php';
    if (file_exists($file)) {
        require_once $file;
        echo "Successfully loaded class: $class<br>";
    } else {
        echo "Failed to load class: $class (file not found: $file)<br>";
    }
});

// Test Config
try {
    $config = Config::getInstance();
    echo "Config loaded successfully<br>";
    var_dump($config->get('db'));
} catch (Exception $e) {
    echo "Config error: " . $e->getMessage() . "<br>";
}

// Test Database
try {
    $db = Database::getInstance();
    echo "Database connected successfully<br>";
} catch (Exception $e) {
    echo "Database error: " . $e->getMessage() . "<br>";
}

// Test Contact
try {
    $contact = new Contact();
    $contacts = $contact->getAll();
    echo "Contacts retrieved successfully. Count: " . count($contacts) . "<br>";
    var_dump($contacts);
} catch (Exception $e) {
    echo "Contact error: " . $e->getMessage() . "<br>";
}