<?php
require_once 'vendor/autoload.php';
require_once 'classes/Config.php';

use Twilio\Jwt\AccessToken;
use Twilio\Jwt\Grants\VoiceGrant;

header('Content-Type: application/json');

try {
    $config = Config::getInstance();
    
    // Create access token
    $token = new AccessToken(
        $config->get('twilio.account_sid'),
        $config->get('twilio.api_key'),
        $config->get('twilio.api_secret'),
        3600,
        'test_user'
    );

    // Create Voice grant
    $voiceGrant = new VoiceGrant();
    $voiceGrant->setOutgoingApplicationSid($config->get('twilio.app_sid'));
    $voiceGrant->setIncomingAllow(true);

    // Add grant to token
    $token->addGrant($voiceGrant);

    // Generate token string
    echo json_encode([
        'success' => true,
        'token' => $token->toJWT(),
        'config' => [
            'account_sid_exists' => !empty($config->get('twilio.account_sid')),
            'api_key_exists' => !empty($config->get('twilio.api_key')),
            'api_secret_exists' => !empty($config->get('twilio.api_secret')),
            'app_sid_exists' => !empty($config->get('twilio.app_sid'))
        ]
    ]);
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?>