<?php
$callLogger = new Call();
$messages = $message->getContactMessages($contactData['id']);
$calls = $callLogger->getByContactId($contactData['id']);
$callStats = $callLogger->getCallStats($contactData['id']);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Contact - <?= htmlspecialchars($contactData['name']) ?></title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <script src="https://media.twiliocdn.com/sdk/js/client/v1.10/twilio.min.js"></script>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/chat.css">
</head>
<body class="bg-gray-100">
    <div class="app-container">
        <!-- Left Sidebar -->
        <div class="sidebar">
            <!-- Contact Header -->
            <div class="p-4 border-b">
                <a href="?page=contacts" class="text-gray-600 hover:text-gray-800 flex items-center gap-2 mb-4">
                    <i class="fas fa-arrow-left"></i> Back to Contacts
                </a>
                <div class="flex items-center gap-4">
                    <div class="w-16 h-16 bg-blue-500 rounded-full flex items-center justify-center text-white text-2xl font-bold">
                        <?= strtoupper(substr($contactData['name'], 0, 1)) ?>
                    </div>
                    <div>
                        <h2 class="text-xl font-bold"><?= htmlspecialchars($contactData['name']) ?></h2>
                        <p class="text-gray-600"><?= htmlspecialchars($contactData['phone']) ?></p>
                        <p class="text-gray-500 text-sm"><?= htmlspecialchars($contactData['email']) ?></p>
                    </div>
                </div>

                <!-- Important: Hidden input for phone number -->
                <input type="hidden" id="contact_phone" value="<?= htmlspecialchars($contactData['phone']) ?>">
                
                <!-- Action Buttons -->
                <div class="flex gap-2 mt-4">
                    <button id="callButton" class="flex-1 bg-green-500 text-white py-2 px-4 rounded hover:bg-green-600 transition flex items-center justify-center gap-2">
                        <i class="fas fa-phone"></i> Call
                    </button>
                    <button id="editButton" class="flex-1 bg-gray-100 text-gray-700 py-2 px-4 rounded hover:bg-gray-200 transition flex items-center justify-center gap-2">
                        <i class="fas fa-edit"></i> Edit
                    </button>
                </div>
            </div>

            <!-- Activity Summary -->
            <div class="p-4 border-b">
                <h3 class="text-lg font-semibold mb-3">Activity Summary</h3>
                <div class="grid grid-cols-2 gap-3">
                    <div class="bg-white p-4 rounded-lg shadow">
                        <div class="text-sm text-gray-600">Total Calls</div>
                        <div class="text-2xl font-bold text-blue-600"><?= $callStats['total_calls'] ?? 0 ?></div>
                        <div class="text-xs text-gray-500">
                            <span class="text-green-500"><?= $callStats['inbound_calls'] ?? 0 ?> in</span> •
                            <span class="text-blue-500"><?= $callStats['outbound_calls'] ?? 0 ?> out</span>
                        </div>
                    </div>
                    <div class="bg-white p-4 rounded-lg shadow">
                        <div class="text-sm text-gray-600">Messages</div>
                        <div class="text-2xl font-bold text-green-600"><?= count($messages) ?></div>
                        <div class="text-xs text-gray-500">Last 30 days</div>
                    </div>
                </div>
            </div>

            <!-- Notes Section -->
            <div class="p-4">
                <h3 class="text-lg font-semibold mb-3">Notes</h3>
                <div class="bg-gray-50 rounded-lg p-3">
                    <p class="text-gray-600 text-sm whitespace-pre-line">
                        <?= nl2br(htmlspecialchars($contactData['notes'] ?: 'No notes added yet.')) ?>
                    </p>
                </div>
            </div>
        </div>

        <!-- Main Content -->
        <div class="main-content flex flex-col">
            <!-- Tabs -->
            <div class="bg-white border-b">
                <div class="flex">
                    <button class="tab active" data-tab="chat">
                        <i class="fas fa-comment"></i> Chat
                    </button>
                    <button class="tab" data-tab="calls">
                        <i class="fas fa-phone"></i> Calls
                    </button>
                    <button class="tab" data-tab="history">
                        <i class="fas fa-history"></i> History
                    </button>
                </div>
            </div>

            <!-- Tab Contents -->
            <div class="flex-1 overflow-hidden">
                <!-- Chat Tab -->
                <div id="chat-tab" class="tab-content active h-full flex flex-col">
                    <!-- Messages Area -->
                    <div id="chat-messages" class="flex-1 overflow-y-auto p-4">
                        <?php foreach ($messages as $message): ?>
                            <div class="message <?= $message['direction'] ?>">
                                <div class="message-content">
                                    <?= htmlspecialchars($message['content']) ?>
                                </div>
                                <div class="message-time">
                                    <?= date('M j, g:i a', strtotime($message['created_at'])) ?>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>

                    <!-- Message Input -->
                    <div class="chat-input bg-white border-t p-4">
                        <form id="message-form" class="flex gap-2">
                            <input type="text" 
                                   id="message-input" 
                                   class="flex-1 rounded-full border-gray-300 focus:border-blue-500 focus:ring focus:ring-blue-200 px-4 py-2"
                                   placeholder="Type a message...">
                            <button type="submit" 
                                    class="bg-blue-500 text-white rounded-full w-10 h-10 flex items-center justify-center hover:bg-blue-600">
                                <i class="fas fa-paper-plane"></i>
                            </button>
                        </form>
                    </div>
                </div>

                <!-- Calls Tab -->
                <div id="calls-tab" class="tab-content hidden h-full overflow-y-auto">
                    <div class="p-4">
                        <div class="bg-white rounded-lg shadow">
                            <div class="p-4 border-b">
                                <h3 class="text-lg font-semibold">Call History</h3>
                            </div>
                            <div class="divide-y">
                                <?php if (!empty($calls)): ?>
                                    <?php foreach ($calls as $call): ?>
                                        <div class="p-4 hover:bg-gray-50">
                                            <div class="flex items-start gap-3">
                                                <div class="w-8 flex-shrink-0">
                                                    <div class="w-8 h-8 rounded-full <?= $call['direction'] === 'inbound' ? 'bg-green-100 text-green-500' : 'bg-blue-100 text-blue-500' ?> flex items-center justify-center">
                                                        <i class="fas fa-phone<?= $call['direction'] === 'outbound' ? '-alt fa-rotate-90' : ' fa-rotate-270' ?>"></i>
                                                    </div>
                                                </div>
                                                <div class="flex-1">
                                                    <div class="flex items-center gap-2">
                                                        <span class="text-sm font-medium">
                                                            <?= date('M j, Y g:i A', strtotime($call['start_time'])) ?>
                                                        </span>
                                                        <span class="text-xs px-2 py-1 rounded-full <?= $call['status'] === 'completed' ? 'bg-green-100 text-green-700' : 'bg-gray-100 text-gray-700' ?>">
                                                            <?= ucfirst($call['status']) ?>
                                                        </span>
                                                    </div>
                                                    <div class="text-xs text-gray-500 mt-1">
                                                        Duration: <?= $call['duration'] ? gmdate("i:s", $call['duration']) : '00:00' ?>
                                                    </div>
                                                    <?php if ($call['recording_url']): ?>
                                                        <div class="mt-2">
                                                            <audio controls class="w-full h-8">
                                                                <source src="<?= htmlspecialchars($call['recording_url']) ?>" type="audio/mpeg">
                                                            </audio>
                                                        </div>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <div class="p-8 text-center text-gray-500">
                                        No call history available
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- History Tab -->
                <div id="history-tab" class="tab-content hidden h-full overflow-y-auto">
                    <div class="p-4">
                        <div class="bg-white rounded-lg shadow">
                            <div class="p-4 border-b">
                                <h3 class="text-lg font-semibold">Activity History</h3>
                            </div>
                            <div class="divide-y">
                                <?php 
                                $timeline = array_merge($messages, $calls);
                                usort($timeline, function($a, $b) {
                                    $aTime = isset($a['created_at']) ? $a['created_at'] : $a['start_time'];
                                    $bTime = isset($b['created_at']) ? $b['created_at'] : $b['start_time'];
                                    return strtotime($bTime) - strtotime($aTime);
                                });
                                
                                foreach ($timeline as $item): 
                                    $isMessage = isset($item['content']);
                                ?>
                                    <div class="p-4 hover:bg-gray-50">
                                        <?php if ($isMessage): ?>
                                            <!-- Message item -->
                                            <div class="flex items-start gap-3">
                                                <div class="w-8 h-8 rounded-full <?= $item['direction'] === 'inbound' ? 'bg-green-100 text-green-500' : 'bg-blue-100 text-blue-500' ?> flex items-center justify-center">
                                                    <i class="fas <?= $item['direction'] === 'inbound' ? 'fa-envelope' : 'fa-paper-plane' ?>"></i>
                                                </div>
                                                <div class="flex-1">
                                                    <div class="text-sm"><?= htmlspecialchars($item['content']) ?></div>
                                                    <div class="text-xs text-gray-500 mt-1">
                                                        <?= date('M j, Y g:i A', strtotime($item['created_at'])) ?>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php else: ?>
                                            <!-- Call item -->
                                            <div class="flex items-start gap-3">
                                                <div class="w-8 h-8 rounded-full <?= $item['direction'] === 'inbound' ? 'bg-green-100 text-green-500' : 'bg-blue-100 text-blue-500' ?> flex items-center justify-center">
                                                    <i class="fas fa-phone<?= $item['direction'] === 'outbound' ? '-alt fa-rotate-90' : ' fa-rotate-270' ?>"></i>
                                                </div>
                                                <div class="flex-1">
                                                    <div class="flex items-center gap-2">
                                                        <span class="text-sm font-medium">Call</span>
                                                        <span class="text-xs px-2 py-1 rounded-full <?= $item['status'] === 'completed' ? 'bg-green-100 text-green-700' : 'bg-gray-100 text-gray-700' ?>">
                                                            <?= ucfirst($item['status']) ?>
                                                        </span>
                                                    </div>
                                                    <div class="text-xs text-gray-500 mt-1">
                                                        <?= date('M j, Y g:i A', strtotime($item['start_time'])) ?>
                                                        • Duration: <?= $item['duration'] ? gmdate("i:s", $item['duration']) : '00:00' ?>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // Initialize managers
        window.chatManager = new ChatManager(<?= $contactData['id'] ?>);
        window.callManager = new CallManager();

        // Tab switching
        const tabs = document.querySelectorAll('.tab');
        tabs.forEach(tab => {
            tab.addEventListener('click', () => {
                // Remove active class from all tabs and content
                document.querySelectorAll('.tab').forEach(t => t.classList.remove('active'));
                document.querySelectorAll('.tab-content').forEach(c => c.classList.add('hidden'));

                // Add active class to clicked tab
                tab.classList.add('active');
                const tabId = `${tab.dataset.tab}-tab`;
                const content = document.getElementById(tabId);
                if (content) {
                    content.classList.remove('hidden');
                }
            });
        });

        // Show chat tab by default
        document.querySelector('[data-tab="chat"]').click();
    });
    </script>