<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/voice_token.log');

require_once 'vendor/autoload.php';
require_once 'classes/Config.php';

use Twilio\Jwt\AccessToken;
use Twilio\Jwt\Grants\VoiceGrant;

header('Content-Type: application/json');

try {
    $config = Config::getInstance();
    
    // Log credentials (remove in production)
    error_log("Account SID: " . substr($config->get('twilio.account_sid'), 0, 10) . "...");
    error_log("API Key: " . substr($config->get('twilio.api_key'), 0, 10) . "...");
    error_log("App SID: " . substr($config->get('twilio.app_sid'), 0, 10) . "...");
    
    // Create access token
    $token = new AccessToken(
        $config->get('twilio.account_sid'),
        $config->get('twilio.api_key'),
        $config->get('twilio.api_secret'),
        3600,
        'browser_user'
    );

    // Create Voice grant
    $voiceGrant = new VoiceGrant();
    $voiceGrant->setOutgoingApplicationSid($config->get('twilio.app_sid'));
    $voiceGrant->setIncomingAllow(true);

    // Add grant to token
    $token->addGrant($voiceGrant);

    // Generate token string
    $tokenString = $token->toJWT();
    
    error_log("Generated token: " . substr($tokenString, 0, 50) . "...");
    
    echo json_encode([
        'success' => true,
        'token' => $tokenString
    ]);
} catch (Exception $e) {
    error_log("Error generating token: " . $e->getMessage());
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}