<?php
require_once dirname(__FILE__) . '/../vendor/autoload.php';
require_once dirname(__FILE__) . '/../classes/Config.php';

use Twilio\Jwt\AccessToken;
use Twilio\Jwt\Grants\VoiceGrant;

header('Content-Type: application/json');

try {
    $config = Config::getInstance();
    
    // Create access token
    $token = new AccessToken(
        $config->get('twilio.account_sid'),
        $config->get('twilio.api_key'),
        $config->get('twilio.api_secret'),
        3600,
        'user_' . rand(1000, 9999)
    );

    // Create Voice grant
    $voiceGrant = new VoiceGrant();
    $voiceGrant->setOutgoingApplicationSid($config->get('twilio.app_sid'));
    $voiceGrant->setIncomingAllow(true);

    // Add grant to token
    $token->addGrant($voiceGrant);

    echo json_encode(['token' => $token->toJWT()]);
} catch (Exception $e) {
    error_log("Token generation error: " . $e->getMessage());
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
}