let device;
let call;

async function initializeDevice() {
    try {
        // Fetch the token from the server
        const response = await fetch('https://la.tarahan.com/tw/webhooks/generate_token.php');
        const data = await response.json();
        const token = data.token;

        // Initialize Twilio Device with the token
        device = new Twilio.Device(token, { debug: true });

        // Event listeners for device readiness, errors, connect, and disconnect
        device.on('ready', () => {
            document.getElementById('status').textContent = 'Device is ready for calls';
            document.getElementById('callButton').disabled = false;
        });

        // Error handling for media access (microphone)
        device.on('error', (error) => {
            if (error.message.includes('microphone')) {
                document.getElementById('status').textContent = 'Error: Could not access microphone. Please check permissions.';
            } else {
                document.getElementById('status').textContent = `Error: ${error.message}`;
            }
            console.error('Twilio.Device Error:', error.message);
        });

        device.on('connect', (connection) => {
            document.getElementById('status').textContent = 'Connected to call';
            document.getElementById('hangUpButton').style.display = 'block';
            document.getElementById('callButton').style.display = 'none';
        });

        device.on('disconnect', () => {
            document.getElementById('status').textContent = 'Call ended';
            document.getElementById('hangUpButton').style.display = 'none';
            document.getElementById('callButton').style.display = 'block';
        });

    } catch (error) {
        document.getElementById('status').textContent = 'Error initializing device';
        console.error('Error initializing device:', error);
    }
}

// Function to make a call
function makeCall() {
    const phoneNumber = document.getElementById('phoneNumber').value.trim();
    if (!phoneNumber) {
        alert('Please enter a valid phone number');
        return;
    }

    if (device) {
        document.getElementById('status').textContent = `Calling ${phoneNumber}...`;
        call = device.connect({ To: phoneNumber });
    } else {
        alert('Device is not ready. Please try again later.');
    }
}

// Function to hang up the call
function hangUpCall() {
    if (call) {
        call.disconnect();
    }
}

// Initialize the Twilio Device when the page loads
window.onload = initializeDevice;
