<?php
require_once dirname(__FILE__) . '/../vendor/autoload.php';
require_once dirname(__FILE__) . '/../classes/Config.php';
require_once dirname(__FILE__) . '/../classes/Database.php';
require_once dirname(__FILE__) . '/../classes/Message.php';
require_once dirname(__FILE__) . '/../classes/Contact.php';

// Log incoming request for debugging
error_log("Twilio Webhook Request: " . print_r($_POST, true));

try {
    // Get the message details
    $from = $_POST['From'] ?? '';
    $body = $_POST['Body'] ?? '';
    
    if (!$from || !$body) {
        throw new Exception("Missing required parameters");
    }

    // Clean phone number
    $from = preg_replace('/[^+0-9]/', '', $from);
    
    // Find the contact
    $contact = new Contact();
    $contactData = $contact->findByPhone($from);
    
    if ($contactData) {
        // Save the message
        $message = new Message();
        $savedMessage = $message->saveInbound($contactData['id'], $body);
        
        if ($savedMessage) {
            error_log("Message saved successfully");
        } else {
            error_log("Failed to save message");
        }
    } else {
        error_log("No contact found for number: " . $from);
    }

    // Send TwiML response
    header('Content-Type: text/xml');
    echo '<?xml version="1.0" encoding="UTF-8"?>';
    echo '<Response></Response>';

} catch (Exception $e) {
    error_log("Webhook Error: " . $e->getMessage());
    
    // Still send a valid TwiML response
    header('Content-Type: text/xml');
    echo '<?xml version="1.0" encoding="UTF-8"?>';
    echo '<Response></Response>';
}