<?php
require_once 'config.php';
require_once 'vendor/autoload.php';
use Twilio\Rest\Client;

function getTwilioClient() {
    return new Client(TWILIO_ACCOUNT_SID, TWILIO_AUTH_TOKEN);
}

function formatPhoneNumber($phone) {
    if (substr($phone, 0, 1) !== '+') {
        return '+' . $phone;
    }
    return $phone;
}

function sendSMS($client, $to, $message) {
    try {
        $message = $client->messages->create(
            formatPhoneNumber($to),
            [
                'from' => TWILIO_PHONE_NUMBER,
                'body' => $message
            ]
        );
        return ['success' => true, 'sid' => $message->sid];
    } catch (Exception $e) {
        error_log("Twilio Error: " . $e->getMessage());
        return ['success' => false, 'error' => $e->getMessage()];
    }
}

function saveMessage($db, $contactId, $content, $direction = 'outbound') {
    $stmt = $db->prepare("INSERT INTO messages (contact_id, direction, content) VALUES (?, ?, ?)");
    return $stmt->execute([$contactId, $direction, $content]);
}

function getContactMessages($db, $contactId, $limit = 5) {
    // Fixed SQL query - removed the parameter binding for LIMIT
    $stmt = $db->prepare("SELECT * FROM messages WHERE contact_id = ? ORDER BY created_at DESC LIMIT 5");
    $stmt->execute([$contactId]);
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}

function getAllContacts($db) {
    return $db->query("SELECT * FROM contacts ORDER BY created_at DESC")->fetchAll();
}