<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Twilio Web Dialer</title>
    <script src="https://media.twiliocdn.com/sdk/js/client/v1.10/twilio.min.js"></script>
    <style>
        body {
            font-family: Arial, sans-serif;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            height: 100vh;
            margin: 0;
            background-color: #f5f5f5;
        }
        .container {
            background-color: #ffffff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0px 4px 8px rgba(0, 0, 0, 0.1);
            text-align: center;
            width: 300px;
        }
        input[type="text"] {
            width: 100%;
            padding: 10px;
            margin-bottom: 10px;
            border: 1px solid #ccc;
            border-radius: 4px;
            font-size: 16px;
        }
        button {
            padding: 10px;
            width: 100%;
            font-size: 16px;
            border: none;
            border-radius: 4px;
            color: #fff;
            cursor: pointer;
            margin-bottom: 10px;
        }
        button#callButton {
            background-color: #4CAF50;
        }
        button#hangUpButton {
            background-color: #f44336;
            display: none;
        }
        .status {
            margin-top: 10px;
            font-size: 14px;
            color: #555;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Twilio Web Dialer</h2>
        <input type="text" id="phoneNumber" placeholder="Enter phone number" />
        <button id="callButton" onclick="makeCall()">Call</button>
        <button id="hangUpButton" onclick="hangUpCall()">Hang Up</button>
        <div class="status" id="status">Initializing device...</div>
    </div>
    <script src="twilio-dialer.js"></script>
</body>
</html>
