<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('log_errors', 1);
ini_set('error_log', dirname(__FILE__) . '/recording_status.log');

require_once dirname(__FILE__) . '/../vendor/autoload.php';
require_once dirname(__FILE__) . '/../classes/Config.php';
require_once dirname(__FILE__) . '/../classes/Call.php';

try {
    // Log incoming request
    error_log("Recording Status Webhook Request: " . print_r($_POST, true));

    $callSid = $_POST['CallSid'] ?? null;
    $recordingUrl = $_POST['RecordingUrl'] ?? null;
    $recordingStatus = $_POST['RecordingStatus'] ?? null;

    error_log("Processing recording - SID: $callSid, Status: $recordingStatus, URL: $recordingUrl");

    if ($callSid && $recordingUrl && $recordingStatus === 'completed') {
        $callLogger = new Call();
        $sql = "UPDATE calls SET recording_url = ? WHERE twilio_sid = ?";
        $stmt = $callLogger->getDb()->prepare($sql);
        $result = $stmt->execute([$recordingUrl, $callSid]);
        
        error_log("Recording URL update " . ($result ? "successful" : "failed"));
    }

    http_response_code(200);
    echo 'Recording status processed';

} catch (Exception $e) {
    error_log("Recording Status Error: " . $e->getMessage());
    error_log("Stack trace: " . $e->getTraceAsString());
    http_response_code(500);
    echo 'Error processing recording status';
}
?>